/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#ifndef _UDM_SPELL_H
#define _UDM_SPELL_H

#include "udm_services.h"

extern __INDLIB__ UDM_SPELL ** UdmNormalizeWord(UDM_AGENT * Indexer, UDM_WIDEWORD *word);
extern __INDLIB__ UDM_WIDEWORDLIST * UdmAllForms(UDM_AGENT * Indexer, UDM_WIDEWORD *word);
extern __INDLIB__ int UdmImportAffixes(UDM_ENV * Conf,const char *lang, const char *charset, const char *filename);
extern __INDLIB__ int UdmImportDictionary(UDM_ENV * Conf,const char *lang, const char *charset, 
					  const char *filename, int skip_noflag, const char *first_letters);

extern __INDLIB__ void UdmSortDictionary(UDM_SPELLLIST *);
extern __INDLIB__ void UdmSortAffixes(UDM_AFFIXLIST *, UDM_SPELLLIST *);

extern int  UdmSpellAdd(UDM_SPELLLIST *,const int * word,const char *flag,const char *lang);
extern int  UdmAffixAdd(UDM_AFFIXLIST *,int flag,const char * lang, const int *mask, const int *find, const int *repl, int type);

extern int  UdmSelectSpellLang(UDM_ENV *Conf, char *lang);
extern void UdmSelectLang(UDM_AGENT *Indexer, char *lang);

extern void UdmSpellListFree(UDM_SPELLLIST *);
extern void UdmAffixListFree(UDM_AFFIXLIST *);

#endif
